REM ***************************************************************************

REM    Oracle Security Probe
REM    Version  : 1.1 public

REM    Author   : Marcel-Jan Krijgsman, Transfer Solutions
REM               www.transfer-solutions.com

REM    Script   : osp_exec.sql
REM    Created  : October 16th 2004
REM    Purpose  : To run Oracle Security Probe
REM    To run as: oraprobe. (created with osp_install_user.sql)

REM ***************************************************************************




REM ************************************************************************
REM The section below must be executed BEFORE the overall spooling starts!!!
REM ************************************************************************

SET PAGESIZE 2000
SET TERMOUT off
SET HEADING off
SET ECHO off
SET VERIFY off
SET FEEDBACK off
SET ARRAYSIZE 1
TTITLE off

COLUMN olddb NEW_VALUE newdb NOPRINT
SELECT lower(global_name) olddb FROM global_name
/

COLUMN tst NEW_VALUE tmstmp
SELECT TO_CHAR(sysdate,'YYYYMMDDHH24MI') tst FROM dual
/

DEFINE streep='_'
DEFINE logstring1=&&newdb&&streep
DEFINE logstring=&&logstring1&&tmstmp

SET SCAN off

SPOOL osp_exec_sub1.sql

SELECT 'SET TERMOUT off' FROM dual;
SELECT 'COLUMN olddb NEW_VALUE newdb NOPRINT' FROM dual;
SELECT 'SELECT LOWER(global_name) olddb FROM global_name;' FROM dual;
SELECT 'COLUMN tst NEW_VALUE tmstmp' FROM dual;
SELECT 'SELECT TO_CHAR(sysdate,''DD-MM-YYYY-HH24MI'') tst FROM dual;' FROM dual;
SELECT 'DEFINE streep=''_''' FROM dual;
SELECT 'DEFINE logstring1=&&newdb&&streep' FROM dual;
SELECT 'DEFINE logstring=&&logstring1&&tmstmp' FROM dual;
SELECT 'SET TERMOUT on' FROM dual;
 
PROMPT

SELECT 'EXIT' FROM dual
/
 
SPOOL off

SET LINESIZE 80
SET PAGESIZE 999
SET FEEDBACK off
SET TIMING   off
SET VERIFY   off
SET NUMWIDTH 10
SET TERMOUT on
SET HEADING on
SET SCAN on




REM ************************************************************************
REM Running of scripts starts here.
REM ************************************************************************


PROMPT *********************************************
PROMPT *                                           *
PROMPT *  Welcome to the Oracle Security Probe     *
PROMPT *                                           *
PROMPT *********************************************
PROMPT

ACCEPT tnsalias		PROMPT 'Connectstring (destination database): '
ACCEPT oraprobe_passw	PROMPT 'Password of oraprobe?: ' hide


CONNECT oraprobe/&oraprobe_passw@&tnsalias

@@osp_exec_accounts.sql
