REM ***************************************************************************

REM    Oracle Security Probe
REM    Version  : 1.1 public

REM    Author   : Marcel-Jan Krijgsman, Transfer Solutions
REM               www.transfer-solutions.com

REM    Script   : osp_install_pack.sql
REM    Created  : October 16th 2004
REM    Purpose  : To install the osp_pack for Oracle Security Probe
REM    To run as: DBA account.

REM ***************************************************************************


CREATE OR REPLACE PACKAGE osp_pack AS

  PROCEDURE default_pass_check;

END osp_pack;
/

show errors


CREATE OR REPLACE PACKAGE BODY osp_pack 
AS

  PROCEDURE default_pass_check
  IS
    CURSOR c_dba_users IS
      SELECT username, password, account_status
      FROM dba_users;

    v_userpass_exists	NUMBER;
    v_default_password	VARCHAR2(30);
    v_security_level	NUMBER;
    v_tel_defaults	NUMBER		:= 0;
    v_commentary	VARCHAR2(200);
    
  BEGIN

    dbms_output.put_line('Oracle accounts with default passwords');
    dbms_output.put_line('======================================'||CHR(10));
    
    -- Loop door de lijst gebruikers en passwords (hash waarde) 
    -- in dba_users.
    FOR r_dba_users IN c_dba_users
    LOOP 
    <<userpass_loop>>
    
      -- Is er een gebruiker/hash waarde combinatie die 
      -- overeenkomt? Vul dan v_userpass_exist met 1.
      SELECT count(*)
      INTO v_userpass_exists
      FROM osp_accounts
      WHERE username=r_dba_users.username
      AND hash_value=r_dba_users.password;
      
      IF v_userpass_exists = 1 THEN
        
        v_tel_defaults := v_tel_defaults + 1;
        -- Als user/hash overeenkomen, haal dan het default
        -- password op uit osp_accounts.
        SELECT password, security_level, commentary
	INTO v_default_password, v_security_level, v_commentary
	FROM osp_accounts
	WHERE username=r_dba_users.username
	AND hash_value=r_dba_users.password;
	
	-- Maak een rapportje
        dbms_output.put_line('Username: '||r_dba_users.username);
        dbms_output.put_line('Password: '||v_default_password);
        IF r_dba_users.account_status LIKE '%LOCKED%' THEN
		dbms_output.put_line('Status: '||r_dba_users.account_status);
	END IF;
        dbms_output.put_line('-----------------------------------------------');
        
        dbms_output.put_line('WARNING! The password of '||r_dba_users.username||' is a default '||
        		     'password. It is well known to hackers'||CHR(10));
        
        -- Hier komt nog een extra melding op basis van commentary
        dbms_output.put_line('Additional information:');
        dbms_output.put_line(v_commentary||CHR(10)||CHR(10));
      END IF;

    END LOOP userpass_loop;
    
    IF v_tel_defaults = 0 THEN
      dbms_output.put_line('No default passwords have been detected.');
    END IF;
  
  END default_pass_check;

END osp_pack;
/

show errors


